/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.effective.cosmetics;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4002;
import net.minecraft.class_5601;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.effective.core.settings.SpawnSettings;
import org.ladysnake.effective.cosmetics.data.AuraData;
import org.ladysnake.effective.cosmetics.data.AuraSettings;
import org.ladysnake.effective.cosmetics.data.OverheadData;
import org.ladysnake.effective.cosmetics.data.PlayerCosmeticData;
import org.ladysnake.effective.cosmetics.particle.aura.AutumnLeavesParticle;
import org.ladysnake.effective.cosmetics.particle.aura.ChorusAuraParticle;
import org.ladysnake.effective.cosmetics.particle.aura.ConfettiParticle;
import org.ladysnake.effective.cosmetics.particle.aura.GhostlyAuraParticle;
import org.ladysnake.effective.cosmetics.particle.aura.GoldenrodAuraParticle;
import org.ladysnake.effective.cosmetics.particle.aura.PrismarineAuraParticle;
import org.ladysnake.effective.cosmetics.particle.aura.PrismaticConfettiParticle;
import org.ladysnake.effective.cosmetics.particle.aura.SculkTendrilParticle;
import org.ladysnake.effective.cosmetics.particle.aura.ShadowbringerParticle;
import org.ladysnake.effective.cosmetics.particle.aura.TwilightLegacyFireflyParticle;
import org.ladysnake.effective.cosmetics.particle.pet.JackoParticle;
import org.ladysnake.effective.cosmetics.particle.pet.PetParticle;
import org.ladysnake.effective.cosmetics.particle.pet.PlayerLanternParticle;
import org.ladysnake.effective.cosmetics.particle.pet.PlayerWispParticle;
import org.ladysnake.effective.cosmetics.particle.pet.PrideHeartParticle;
import org.ladysnake.effective.cosmetics.render.entity.feature.OverheadFeatureRenderer;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.CrownModel;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.HaloModel;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.HornsModel;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.TiaraModel;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.VoidheartTiaraModel;
import org.ladysnake.effective.cosmetics.render.entity.model.hat.WreathModel;
import org.ladysnake.effective.cosmetics.render.entity.model.pet.LanternModel;
import org.ladysnake.effective.cosmetics.render.entity.model.pet.PrideHeartModel;
import org.ladysnake.effective.cosmetics.render.entity.model.pet.WillOWispModel;

@Environment(value=EnvType.CLIENT)
public class EffectiveCosmetics
implements ClientModInitializer {
    public static final String MODID = "effective_cosmetics";
    public static final int EYES_VANISHING_DISTANCE = 5;
    public static final Gson COSMETICS_GSON = new GsonBuilder().registerTypeAdapter(PlayerCosmeticData.class, (Object)new PlayerCosmeticDataParser()).create();
    static final Type COSMETIC_SELECT_TYPE = new TypeToken<Map<UUID, PlayerCosmeticData>>(){}.getType();
    private static final String COSMETICS_URL = "https://doctor4t.ladysnake.org/illuminations-data";
    public static ImmutableMap<String, AuraData> AURAS_DATA;
    public static ImmutableMap<String, class_2400> PETS_DATA;
    public static ImmutableMap<String, OverheadData> OVERHEADS_DATA;
    public static class_2400 TWILIGHT_AURA;
    public static class_2400 GHOSTLY_AURA;
    public static class_2400 CHORUS_AURA;
    public static class_2400 AUTUMN_LEAVES_AURA;
    public static class_2400 SCULK_TENDRIL_AURA;
    public static class_2400 SHADOWBRINGER_AURA;
    public static class_2400 GOLDENROD_AURA;
    public static class_2400 CONFETTI_AURA;
    public static class_2400 PRISMATIC_CONFETTI_AURA;
    public static class_2400 PRISMARINE_AURA;
    public static class_2400 PRIDE_PET;
    public static class_2400 GAY_PRIDE_PET;
    public static class_2400 TRANS_PRIDE_PET;
    public static class_2400 JACKO_PET;
    public static class_2400 LESBIAN_PRIDE_PET;
    public static class_2400 BI_PRIDE_PET;
    public static class_2400 ACE_PRIDE_PET;
    public static class_2400 NB_PRIDE_PET;
    public static class_2400 INTERSEX_PRIDE_PET;
    public static class_2400 ARO_PRIDE_PET;
    public static class_2400 PAN_PRIDE_PET;
    public static class_2400 AGENDER_PRIDE_PET;
    public static class_2400 GENDERFLUID_PRIDE_PET;
    public static class_2400 WILL_O_WISP_PET;
    public static class_2400 DISSOLUTION_WISP_PET;
    public static class_2400 PUMPKIN_SPIRIT_PET;
    public static class_2400 POLTERGEIST_PET;
    public static class_2400 LANTERN_PET;
    public static class_2400 SOUL_LANTERN_PET;
    public static class_2400 CRYING_LANTERN_PET;
    public static class_2400 SOOTHING_LANTERN_PET;
    private static Map<UUID, PlayerCosmeticData> PLAYER_COSMETICS;

    @Nullable
    public static PlayerCosmeticData getCosmeticData(class_1657 player) {
        return PLAYER_COSMETICS.get(player.method_5667());
    }

    public static void loadPlayerCosmetics() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Map map;
            InputStreamReader reader = new InputStreamReader(new URL(COSMETICS_URL).openStream());
            try {
                map = (Map)COSMETICS_GSON.fromJson((Reader)reader, COSMETIC_SELECT_TYPE);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
            return map;
        }).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        })).thenAcceptAsync(playerData -> {
            PLAYER_COSMETICS = playerData != null ? playerData : Collections.emptyMap();
        }, (Executor)class_310.method_1551());
    }

    public static boolean isNightTime(class_1937 world) {
        return (double)world.method_30274((float)world.method_8532()) >= 0.25965086 && (double)world.method_30274((float)world.method_8532()) <= 0.7403491;
    }

    public void onInitializeClient() {
        EffectiveCosmetics.loadPlayerCosmetics();
        EntityModelLayerRegistry.registerModelLayer((class_5601)CrownModel.MODEL_LAYER, CrownModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HornsModel.MODEL_LAYER, HornsModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)HaloModel.MODEL_LAYER, HaloModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)TiaraModel.MODEL_LAYER, TiaraModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)VoidheartTiaraModel.MODEL_LAYER, VoidheartTiaraModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WreathModel.MODEL_LAYER, WreathModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)WillOWispModel.MODEL_LAYER, WillOWispModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)LanternModel.MODEL_LAYER, LanternModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((class_5601)PrideHeartModel.MODEL_LAYER, PrideHeartModel::getTexturedModelData);
        TWILIGHT_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"twilight_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)TWILIGHT_AURA, TwilightLegacyFireflyParticle.DefaultFactory::new);
        GHOSTLY_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"ghostly_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GHOSTLY_AURA, GhostlyAuraParticle.DefaultFactory::new);
        CHORUS_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"chorus_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CHORUS_AURA, ChorusAuraParticle.DefaultFactory::new);
        AUTUMN_LEAVES_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"autumn_leaves"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)AUTUMN_LEAVES_AURA, AutumnLeavesParticle.DefaultFactory::new);
        SCULK_TENDRIL_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"sculk_tendril"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SCULK_TENDRIL_AURA, SculkTendrilParticle.DefaultFactory::new);
        SHADOWBRINGER_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"shadowbringer_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SHADOWBRINGER_AURA, ShadowbringerParticle.DefaultFactory::new);
        GOLDENROD_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"goldenrod_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GOLDENROD_AURA, GoldenrodAuraParticle.DefaultFactory::new);
        CONFETTI_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"confetti"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CONFETTI_AURA, ConfettiParticle.DefaultFactory::new);
        PRISMATIC_CONFETTI_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"prismatic_confetti"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRISMATIC_CONFETTI_AURA, PrismaticConfettiParticle.DefaultFactory::new);
        PRISMARINE_AURA = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"prismarine_aura"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRISMARINE_AURA, PrismarineAuraParticle.DefaultFactory::new);
        PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/pride_heart.png"), 1.0f, 1.0f, 1.0f));
        GAY_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"gay_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GAY_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/gay_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        TRANS_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"trans_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)TRANS_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/trans_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        LESBIAN_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"lesbian_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)LESBIAN_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/lesbian_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        BI_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"bi_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)BI_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/bi_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        ACE_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"ace_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)ACE_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/ace_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        NB_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"nb_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)NB_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/nb_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        INTERSEX_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"intersex_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)INTERSEX_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/intersex_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        ARO_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"aro_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)ARO_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/aro_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        PAN_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"pan_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PAN_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/pan_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        AGENDER_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"agender_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)AGENDER_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/agender_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        GENDERFLUID_PRIDE_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"genderfluid_pride_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)GENDERFLUID_PRIDE_PET, fabricSpriteProvider -> new PrideHeartParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/genderfluid_pride_heart.png"), 1.0f, 1.0f, 1.0f));
        WILL_O_WISP_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"will_o_wisp_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)WILL_O_WISP_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/will_o_wisp.png"), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
        DISSOLUTION_WISP_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"dissolution_wisp_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)DISSOLUTION_WISP_PET, PetParticle.DefaultFactory::new);
        JACKO_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"jacko_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)JACKO_PET, JackoParticle.DefaultFactory::new);
        PUMPKIN_SPIRIT_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"pumpkin_spirit_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)PUMPKIN_SPIRIT_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/pumpkin_spirit.png"), 1.0f, 0.95f, 0.0f, 0.0f, -0.03f, 0.0f));
        POLTERGEIST_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"poltergeist_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)POLTERGEIST_PET, fabricSpriteProvider -> new PlayerWispParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/poltergeist.png"), 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        LANTERN_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"lantern_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/lantern.png"), 1.0f, 1.0f, 1.0f));
        SOUL_LANTERN_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"soul_lantern_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SOUL_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/soul_lantern.png"), 1.0f, 1.0f, 1.0f));
        CRYING_LANTERN_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"crying_lantern_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CRYING_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/crying_lantern.png"), 1.0f, 1.0f, 1.0f));
        SOOTHING_LANTERN_PET = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_43902((String)MODID, (String)"soothing_lantern_pet"), (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)SOOTHING_LANTERN_PET, fabricSpriteProvider -> new PlayerLanternParticle.DefaultFactory((class_4002)fabricSpriteProvider, class_2960.method_43902((String)MODID, (String)"textures/entity/soothing_lantern.png"), 1.0f, 1.0f, 1.0f));
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityType == class_1299.field_6097) {
                class_922 playerRenderer = entityRenderer;
                registrationHelper.register((class_3887)new OverheadFeatureRenderer((class_3883<class_742, class_591<class_742>>)playerRenderer, context));
            }
        });
        AURAS_DATA = ImmutableMap.builder().put((Object)"twilight", (Object)new AuraData(TWILIGHT_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"twilight"))).put((Object)"ghostly", (Object)new AuraData(GHOSTLY_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"ghostly"))).put((Object)"chorus", (Object)new AuraData(CHORUS_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"chorus"))).put((Object)"autumn_leaves", (Object)new AuraData(AUTUMN_LEAVES_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"autumn_leaves"))).put((Object)"sculk_tendrils", (Object)new AuraData(SCULK_TENDRIL_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"sculk_tendrils"))).put((Object)"shadowbringer_soul", (Object)new AuraData(SHADOWBRINGER_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"shadowbringer_soul"))).put((Object)"goldenrod", (Object)new AuraData(GOLDENROD_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"goldenrod"))).put((Object)"confetti", (Object)new AuraData(CONFETTI_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"confetti"))).put((Object)"prismatic_confetti", (Object)new AuraData(PRISMATIC_CONFETTI_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"prismatic_confetti"))).put((Object)"prismarine", (Object)new AuraData(PRISMARINE_AURA, () -> (AuraSettings)SpawnSettings.AURAS.get((Object)"prismarine"))).build();
        OVERHEADS_DATA = ImmutableMap.builder().put((Object)"solar_crown", (Object)new OverheadData(CrownModel::new, "solar_crown")).put((Object)"frost_crown", (Object)new OverheadData(CrownModel::new, "frost_crown")).put((Object)"pyro_crown", (Object)new OverheadData(CrownModel::new, "pyro_crown")).put((Object)"chorus_crown", (Object)new OverheadData(CrownModel::new, "chorus_crown")).put((Object)"bloodfiend_crown", (Object)new OverheadData(CrownModel::new, "bloodfiend_crown")).put((Object)"dreadlich_crown", (Object)new OverheadData(CrownModel::new, "dreadlich_crown")).put((Object)"mooncult_crown", (Object)new OverheadData(CrownModel::new, "mooncult_crown")).put((Object)"deepsculk_horns", (Object)new OverheadData(HornsModel::new, "deepsculk_horns")).put((Object)"springfae_horns", (Object)new OverheadData(HornsModel::new, "springfae_horns")).put((Object)"voidheart_tiara", (Object)new OverheadData(VoidheartTiaraModel::new, "voidheart_tiara")).put((Object)"worldweaver_halo", (Object)new OverheadData(HaloModel::new, "worldweaver_halo")).put((Object)"summerbreeze_wreath", (Object)new OverheadData(WreathModel::new, "summerbreeze_wreath")).put((Object)"glowsquid_cult_crown", (Object)new OverheadData(TiaraModel::new, "glowsquid_cult_crown")).put((Object)"timeaspect_cult_crown", (Object)new OverheadData(TiaraModel::new, "timeaspect_cult_crown")).put((Object)"prismarine_crown", (Object)new OverheadData(CrownModel::new, "prismarine_crown")).build();
        PETS_DATA = ImmutableMap.builder().put((Object)"pride", (Object)PRIDE_PET).put((Object)"gay_pride", (Object)GAY_PRIDE_PET).put((Object)"trans_pride", (Object)TRANS_PRIDE_PET).put((Object)"lesbian_pride", (Object)LESBIAN_PRIDE_PET).put((Object)"bi_pride", (Object)BI_PRIDE_PET).put((Object)"ace_pride", (Object)ACE_PRIDE_PET).put((Object)"nb_pride", (Object)NB_PRIDE_PET).put((Object)"intersex_pride", (Object)INTERSEX_PRIDE_PET).put((Object)"aro_pride", (Object)ARO_PRIDE_PET).put((Object)"pan_pride", (Object)PAN_PRIDE_PET).put((Object)"agender_pride", (Object)AGENDER_PRIDE_PET).put((Object)"genderfluid_pride", (Object)GENDERFLUID_PRIDE_PET).put((Object)"jacko", (Object)JACKO_PET).put((Object)"will_o_wisp", (Object)WILL_O_WISP_PET).put((Object)"dissolution_wisp", (Object)DISSOLUTION_WISP_PET).put((Object)"pumpkin_spirit", (Object)PUMPKIN_SPIRIT_PET).put((Object)"poltergeist", (Object)POLTERGEIST_PET).put((Object)"lantern", (Object)LANTERN_PET).put((Object)"soul_lantern", (Object)SOUL_LANTERN_PET).put((Object)"crying_lantern", (Object)CRYING_LANTERN_PET).put((Object)"soothing_lantern", (Object)SOOTHING_LANTERN_PET).build();
    }

    static {
        PLAYER_COSMETICS = Collections.emptyMap();
    }

    @Environment(value=EnvType.CLIENT)
    private static class PlayerCosmeticDataParser
    implements JsonDeserializer<PlayerCosmeticData> {
        private PlayerCosmeticDataParser() {
        }

        public PlayerCosmeticData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return new PlayerCosmeticData(jsonObject.get("aura"), jsonObject.get("color"), jsonObject.get("color2"), jsonObject.get("overhead"), jsonObject.get("pet"));
        }
    }
}

