/*
 * Decompiled with CFR 0.152.
 */
package net.berserker_rpg.item.weapons;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.berserker_rpg.item.BerserkerGroup;
import net.berserker_rpg.item.weapons.BerserkerAxeItem;
import net.berserker_rpg.item.weapons.FrozenBerserkerAxeItem;
import net.berserker_rpg.item.weapons.SoulBerserkerAxeItem;
import net.berserker_rpg.item.weapons.ThunderBerserkerAxeItem;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.spell_engine.api.item.ItemConfig;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    public static float berserker_axe_attackSpeed = -3.1f;
    public static final Weapon.Entry flint_berserker_axe = WeaponsRegister.berserker_axes("flint_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8922, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8145})), 7.0f, false);
    public static final Weapon.Entry stone_berserker_axe = WeaponsRegister.berserker_axes("stone_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8927, () -> class_1856.method_8106((class_6862)class_3489.field_23802)), 9.0f, false).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.01f));
    public static final Weapon.Entry iron_berserker_axe = WeaponsRegister.berserker_axes("iron_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8923, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})), 9.0f, false).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.02f));
    public static final Weapon.Entry golden_berserker_axe = WeaponsRegister.berserker_axes("golden_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8929, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})), 7.0f, false).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.02f));
    public static final Weapon.Entry diamond_berserker_axe = WeaponsRegister.berserker_axes("diamond_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_8930, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 10.5f, false).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.035f));
    public static final Weapon.Entry netherite_berserker_axe = WeaponsRegister.berserker_axes("netherite_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 12.0f, true).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.05f));
    public static final Weapon.Entry frozen_berserker_axe = WeaponsRegister.special_berserker_axe_1("frozen_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 11.5f, true).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.075f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.FROST.id, (float)3.0f));
    public static final Weapon.Entry thunder_berserker_axe = WeaponsRegister.special_berserker_axe_2("thunder_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477})), 11.5f, true).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.075f)).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.LIGHTNING.id, (float)3.0f));
    public static final Weapon.Entry soul_berserker_axe = WeaponsRegister.special_berserker_axe_3("soul_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, () -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020})), 12.5f, true).attribute(ItemConfig.Attribute.bonus((class_2960)SpellSchools.SOUL.id, (float)4.0f)).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:lifesteal_modifier")), (float)0.1f)).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.1f));
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults) {
        return WeaponsRegister.entry(null, name, material, item, defaults);
    }

    private static Weapon.Entry entry(String requiredMod, String name, Weapon.CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults) {
        Weapon.Entry entry = new Weapon.Entry("berserker_rpg", name, material, item, defaults, null);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<class_1856> ingredient(String idString) {
        return WeaponsRegister.ingredient(idString, class_1802.field_8477);
    }

    private static Supplier<class_1856> ingredient(String idString, class_1792 fallback) {
        class_2960 id = new class_2960(idString);
        return () -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
            class_1792 ingredient = item != null ? item : fallback;
            return class_1856.method_8091((class_1935[])new class_1935[]{ingredient});
        };
    }

    private static Weapon.Entry berserker_axes(String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        return WeaponsRegister.berserker_axes(null, name, material, damage, fireproof);
    }

    private static Weapon.Entry berserker_axes(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        BerserkerAxeItem item = new BerserkerAxeItem((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, berserker_axe_attackSpeed));
    }

    private static Weapon.Entry special_berserker_axe_1(String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        return WeaponsRegister.special_berserker_axe_1(null, name, material, damage, fireproof);
    }

    private static Weapon.Entry special_berserker_axe_1(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        FrozenBerserkerAxeItem item = new FrozenBerserkerAxeItem((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, berserker_axe_attackSpeed));
    }

    private static Weapon.Entry special_berserker_axe_2(String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        return WeaponsRegister.special_berserker_axe_2(null, name, material, damage, fireproof);
    }

    private static Weapon.Entry special_berserker_axe_2(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        ThunderBerserkerAxeItem item = new ThunderBerserkerAxeItem((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, berserker_axe_attackSpeed));
    }

    private static Weapon.Entry special_berserker_axe_3(String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        return WeaponsRegister.special_berserker_axe_3(null, name, material, damage, fireproof);
    }

    private static Weapon.Entry special_berserker_axe_3(String requiredMod, String name, Weapon.CustomMaterial material, float damage, boolean fireproof) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (fireproof) {
            settings = settings.method_24359();
        }
        SoulBerserkerAxeItem item = new SoulBerserkerAxeItem((class_1832)material, settings);
        return WeaponsRegister.entry(requiredMod, name, material, (class_1792)item, new ItemConfig.Weapon(damage, berserker_axe_attackSpeed));
    }

    public static void register(Map<String, ItemConfig.Weapon> configs) {
        Supplier<class_1856> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby");
            WeaponsRegister.berserker_axes(BETTER_NETHER, "ruby_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 15.0f, true).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.1f));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot");
            WeaponsRegister.berserker_axes(BETTER_END, "aeternium_berserker_axe", Weapon.CustomMaterial.matching((class_1834)class_1834.field_22033, repair), 15.0f, true).attribute(ItemConfig.Attribute.multiply((class_2960)Objects.requireNonNull(class_2960.method_12829((String)"more_rpg_classes:rage_modifier")), (float)0.1f));
        }
        Weapon.register(configs, entries, BerserkerGroup.BERSERKER_KEY);
    }
}

