/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.structure.condition.StructureCondition;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3195;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_6497;

public record HeightFilterStructureCondition(RangeType rangeType, Optional<class_2902.class_2903> heightmap, class_6497<Integer> permittedRange) implements StructureCondition
{
    public static final MapCodec<HeightFilterStructureCondition> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)RangeType.CODEC.fieldOf("range_type").forGetter(HeightFilterStructureCondition::rangeType), (App)class_2902.class_2903.field_24772.optionalFieldOf("heightmap").forGetter(HeightFilterStructureCondition::heightmap), (App)class_6497.field_34390.fieldOf("permitted_range").forGetter(HeightFilterStructureCondition::permittedRange)).apply((Applicative)instance, HeightFilterStructureCondition::new)), HeightFilterStructureCondition::validate);

    private DataResult<HeightFilterStructureCondition> validate() {
        if (this.rangeType == RangeType.HEIGHTMAP_RELATIVE && this.heightmap.isEmpty()) {
            return DataResult.error(() -> "Heightmap relative range type must be used with a heightmap");
        }
        return DataResult.success((Object)this);
    }

    @Override
    public boolean test(class_3195.class_7149 context, class_2338 pos) {
        if (this.heightmap.isEmpty()) {
            return this.permittedRange.method_37955((Comparable)Integer.valueOf(pos.method_10264()));
        }
        int heightmapY = context.comp_562().method_20402(pos.method_10263(), pos.method_10260(), this.heightmap.get(), context.comp_569(), context.comp_564());
        int y = this.rangeType == RangeType.ABSOLUTE ? heightmapY : pos.method_10264() - heightmapY;
        return this.permittedRange.method_37955((Comparable)Integer.valueOf(y));
    }

    @Override
    public MapCodec<? extends StructureCondition> codec() {
        return CODEC;
    }

    public static enum RangeType implements class_3542
    {
        ABSOLUTE("absolute"),
        HEIGHTMAP_RELATIVE("heightmap_relative");

        public static final Codec<RangeType> CODEC;
        private final String name;

        private RangeType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(RangeType::values);
        }
    }
}

