/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.curses;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnBreakSpeedGet;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemSwingDurationGet;
import com.majruszlibrary.events.OnItemUseTicked;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1884;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_5134;

@AutoInstance
public class FatigueCurse
extends Handler {
    static final Range<Float> MULTIPLIER = Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));
    final AttributeHandler attackSpeed = new AttributeHandler("%s_attack_speed".formatted(this.enchantment.getId()), () -> class_5134.field_23723, class_1322.class_1323.field_6331);
    final AttributeHandler movementSpeed = new AttributeHandler("%s_movement_speed".formatted(this.enchantment.getId()), () -> class_5134.field_23719, class_1322.class_1323.field_6331);
    float miningMultiplier = 0.8f;
    float attackMultiplier = 0.8f;
    float movingMultiplier = 0.95f;
    float usingMultiplier = 0.8f;
    float swingingMultiplier = 0.8f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9088).category(class_1886.field_9082).slots((List)EquipmentSlots.ALL).curse().maxLevel(3).minLevelCost(level -> 10).maxLevelCost(level -> 50).compatibility(enchantment -> !(enchantment instanceof class_1884));
    }

    public FatigueCurse() {
        super(MajruszsEnchantments.FATIGUE, FatigueCurse.class, true);
        OnBreakSpeedGet.listen(this::reduceMiningSpeed).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.player));
        OnItemEquipped.listen(this::reduceAttackSpeed);
        OnItemEquipped.listen(this::reduceMovementSpeed);
        OnItemUseTicked.listen(this::reduceUseSpeed).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.entity)).addCondition(data -> Random.check((float)(1.0f - this.getItemMultiplier(this.usingMultiplier, data.entity))));
        OnItemSwingDurationGet.listen(this::increaseSwingDuration).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.entity));
        this.config.define("speed_multiplier_per_level", subconfig -> {
            subconfig.define("mining", Reader.number(), s -> Float.valueOf(this.miningMultiplier), (s, v) -> {
                this.miningMultiplier = ((Float)MULTIPLIER.clamp((Number)v)).floatValue();
            });
            subconfig.define("attacking", Reader.number(), s -> Float.valueOf(this.attackMultiplier), (s, v) -> {
                this.attackMultiplier = ((Float)MULTIPLIER.clamp((Number)v)).floatValue();
            });
            subconfig.define("moving", Reader.number(), s -> Float.valueOf(this.movingMultiplier), (s, v) -> {
                this.movingMultiplier = ((Float)MULTIPLIER.clamp((Number)v)).floatValue();
            });
            subconfig.define("item_using", Reader.number(), s -> Float.valueOf(this.usingMultiplier), (s, v) -> {
                this.usingMultiplier = ((Float)MULTIPLIER.clamp((Number)v)).floatValue();
            });
            subconfig.define("item_swinging", Reader.number(), s -> Float.valueOf(this.swingingMultiplier), (s, v) -> {
                this.swingingMultiplier = ((Float)MULTIPLIER.clamp((Number)v)).floatValue();
            });
        });
    }

    private void reduceMiningSpeed(OnBreakSpeedGet data) {
        data.speed *= Math.max(this.getItemMultiplier(this.miningMultiplier, (class_1309)data.player), 0.01f);
    }

    private void reduceAttackSpeed(OnItemEquipped data) {
        this.attackSpeed.setValue((double)(this.getItemMultiplier(this.attackMultiplier, data.entity) - 1.0f)).apply(data.entity);
    }

    private void reduceMovementSpeed(OnItemEquipped data) {
        this.movementSpeed.setValue((double)(this.getArmorMultiplier(this.movingMultiplier, data.entity) - 1.0f)).apply(data.entity);
    }

    private void reduceUseSpeed(OnItemUseTicked data) {
        ++data.duration;
    }

    private void increaseSwingDuration(OnItemSwingDurationGet data) {
        data.duration = (int)((float)data.duration + (float)data.original * (1.0f - this.getItemMultiplier(this.swingingMultiplier, data.entity)));
    }

    private float getItemMultiplier(float multiplier, class_1309 entity) {
        return (float)Math.pow(multiplier, EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)entity.method_6047()));
    }

    private float getArmorMultiplier(float multiplier, class_1309 entity) {
        return (float)Math.pow(multiplier, EnchantmentHelper.getLevelSum((Supplier)this.enchantment, (class_1309)entity, (Iterable)EquipmentSlots.ARMOR));
    }
}

