/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@AutoInstance
public class DodgeEnchantment
extends Handler {
    float chance = 0.125f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9088).category(class_1886.field_9076).slots((List)EquipmentSlots.LEGS).maxLevel(2).minLevelCost(level -> level * 14).maxLevelCost(level -> level * 14 + 20);
    }

    public DodgeEnchantment() {
        super(MajruszsEnchantments.DODGE, DodgeEnchantment.class, false);
        OnEntityPreDamaged.listen(this::dodge).addCondition(Condition.isLogicalServer()).addCondition(OnEntityPreDamaged::willTakeFullDamage).addCondition(data -> data.attacker != null).addCondition(data -> Random.check((float)((float)EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1309)data.target) * this.chance)));
        this.config.define("dodge_chance_per_level", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
            this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void dodge(OnEntityPreDamaged data) {
        int invisibleDuration = TimeHelper.toTicks((double)1.0);
        data.cancelDamage();
        this.spawnEffects(data, invisibleDuration);
        MajruszLibrary.ENTITY_INVISIBLE.sendToClients((Object)new EntityHelper.EntityInvisible((class_1297)data.target, invisibleDuration));
    }

    private void spawnEffects(OnEntityPreDamaged data, int invisibleDuration) {
        TimeHelper.slider((int)invisibleDuration, slider -> {
            boolean isFirstOrLastTick = slider.getTicksLeft() == slider.getTicksTotal() || slider.getTicksLeft() == 0;
            float width = data.target.method_17681();
            float height = data.target.method_17682();
            int count = 1;
            if (isFirstOrLastTick) {
                count = 20;
                SoundEmitter.of((class_3414)class_3417.field_15102).position(data.target.method_19538()).volume(SoundEmitter.randomized((float)0.25f)).pitch(SoundEmitter.randomized((float)0.4f)).emit((class_1937)data.getServerLevel());
            }
            ParticleEmitter.of(MajruszsEnchantments.DODGE_PARTICLE).sizeBased((class_1297)data.target).count(count).offset(() -> AnyPos.from((Number)Float.valueOf(width), (Number)Float.valueOf(height), (Number)Float.valueOf(width)).mul((Number)Float.valueOf(1.0f), (Number)Float.valueOf(0.25f), (Number)Float.valueOf(1.0f)).vec3()).speed(0.025f).emit((class_1937)data.getServerLevel());
        });
    }
}

