/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.collection.DefaultMap;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnFishingExtraItemsGet;
import com.majruszlibrary.events.OnItemEquipped;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_39;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_8567;

@AutoInstance
public class FishingFanaticEnchantment
extends Handler {
    final AttributeHandler attackSpeed;
    class_2960 specialDropId = MajruszsEnchantments.HELPER.getLocation("gameplay/fishing/fishing_fanatic_extra");
    Map<String, Float> levelUpChance = DefaultMap.of((DefaultMap.Entry[])new DefaultMap.Entry[]{DefaultMap.defaultEntry((Object)Float.valueOf(0.06f)), DefaultMap.entry((String)"level_2", (Object)Float.valueOf(0.05f)), DefaultMap.entry((String)"level_3", (Object)Float.valueOf(0.04f)), DefaultMap.entry((String)"level_4", (Object)Float.valueOf(0.03f)), DefaultMap.entry((String)"level_5", (Object)Float.valueOf(0.02f)), DefaultMap.entry((String)"level_6", (Object)Float.valueOf(0.01f)), DefaultMap.entry((String)"level_7", (Object)Float.valueOf(0.004f)), DefaultMap.entry((String)"level_8", (Object)Float.valueOf(0.002f))});
    Map<String, Float> specialDropChance = DefaultMap.of((DefaultMap.Entry[])new DefaultMap.Entry[]{DefaultMap.defaultEntry((Object)Float.valueOf(0.0f)), DefaultMap.entry((String)"level_4", (Object)Float.valueOf(0.0025f)), DefaultMap.entry((String)"level_5", (Object)Float.valueOf(0.0075f)), DefaultMap.entry((String)"level_6", (Object)Float.valueOf(0.02f)), DefaultMap.entry((String)"level_7", (Object)Float.valueOf(0.04f)), DefaultMap.entry((String)"level_8", (Object)Float.valueOf(0.06f))});
    float extraLootChance = 0.33333f;
    float rainMultiplier = 2.0f;
    float damageBonus = 1.0f;
    float attackSpeedMultiplier = 0.82f;

    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public class_2561 method_8179(int level) {
                if (level == this.method_8183()) {
                    return TextHelper.translatable((String)"enchantment.majruszsenchantments.fishing_fanatic.true", (Object[])new Object[0]).method_27692(class_124.field_1080);
                }
                return super.method_8179(level);
            }

            public boolean method_25949() {
                return false;
            }

            public boolean method_8193() {
                return true;
            }
        }.rarity(class_1887.class_1888.field_9090).category(class_1886.field_9072).slots((List)EquipmentSlots.HANDS).maxLevel(8).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 20);
    }

    public FishingFanaticEnchantment() {
        super(MajruszsEnchantments.FISHING_FANATIC, FishingFanaticEnchantment.class, false);
        this.attackSpeed = new AttributeHandler("%s_attack_speed".formatted(this.enchantment.getId()), () -> class_5134.field_23723, class_1322.class_1323.field_6331);
        OnFishingExtraItemsGet.listen(this::increaseLoot).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.player));
        OnEntityPreDamaged.listen(this::increaseDamage).addCondition(OnEntityPreDamaged::willTakeFullDamage).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.attacker));
        OnItemEquipped.listen(this::reduceAttackSpeed);
        OnItemFished.listen(this::tryToLevelUp).priority(Priority.LOW);
        this.config.define("extra_loot_chance", Reader.number(), s -> Float.valueOf(this.extraLootChance), (s, v) -> {
            this.extraLootChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("level_up_chance", Reader.map((IReader)Reader.number()), s -> this.levelUpChance, (s, v) -> {
            this.levelUpChance = Range.CHANCE.clamp((Map)DefaultMap.of((Map)v));
        }).define("level_up_chance_rain_multiplier", Reader.number(), s -> Float.valueOf(this.rainMultiplier), (s, v) -> {
            this.rainMultiplier = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("special_drop_chance", Reader.map((IReader)Reader.number()), s -> this.specialDropChance, (s, v) -> {
            this.specialDropChance = Range.CHANCE.clamp((Map)DefaultMap.of((Map)v));
        }).define("special_drop_id", Reader.location(), s -> this.specialDropId, (s, v) -> {
            this.specialDropId = v;
        }).define("damage_bonus_per_level", Reader.number(), s -> Float.valueOf(this.damageBonus), (s, v) -> {
            this.damageBonus = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        }).define("attack_speed_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.attackSpeedMultiplier), (s, v) -> {
            this.attackSpeedMultiplier = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void increaseLoot(OnFishingExtraItemsGet data) {
        class_1799 fishingRod = data.fishingRod;
        int level = EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)fishingRod);
        List<class_1799> loot = this.spawnExtraLoot(data, level);
        if (!loot.isEmpty()) {
            data.extraExperience += loot.size() + Random.nextInt((int)(2 * loot.size())) + 1;
            data.extraItems.addAll(loot);
        }
    }

    private List<class_1799> spawnExtraLoot(OnFishingExtraItemsGet data, int level) {
        class_8567 lootParams = LootHelper.toGiftParams((class_1297)data.player);
        class_52 standard = LootHelper.getLootTable((class_2960)class_39.field_353);
        class_52 special = LootHelper.getLootTable((class_2960)this.specialDropId);
        ArrayList<class_1799> extraLoot = new ArrayList<class_1799>();
        for (int idx = 0; idx < level; ++idx) {
            if (!Random.check((float)this.extraLootChance)) continue;
            class_52 lootTable = Random.check((float)this.specialDropChance.get("level_%d".formatted(level)).floatValue()) ? special : standard;
            extraLoot.addAll((Collection<class_1799>)lootTable.method_51878(lootParams));
        }
        return extraLoot;
    }

    private void tryToLevelUp(OnItemFished data) {
        class_1799 fishingRod;
        int level;
        float chanceMultiplier;
        boolean isRaining = data.getLevel().method_8419();
        float f = chanceMultiplier = isRaining ? this.rainMultiplier : 1.0f;
        if (!this.isEnabled) {
            chanceMultiplier = 0.0f;
        }
        if ((level = EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)(fishingRod = ItemHelper.getHandItem((class_1309)data.player, itemStack -> itemStack.method_7909() instanceof class_1787)))) == ((CustomEnchantment)this.enchantment.get()).method_8183() || !Random.check((float)(this.levelUpChance.get("level_%d".formatted(level)).floatValue() * chanceMultiplier))) {
            return;
        }
        EnchantmentHelper.increaseLevel((Supplier)this.enchantment, (class_1799)fishingRod);
        ++level;
        class_1657 class_16572 = data.player;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            if (level == 1) {
                MajruszsEnchantments.HELPER.triggerAchievement(player, "fishing_fanatic");
            }
            if (level == ((CustomEnchantment)this.enchantment.get()).method_8183()) {
                MajruszsEnchantments.HELPER.triggerAchievement(player, "fishing_fanatic_true");
            }
            if (isRaining) {
                MajruszsEnchantments.HELPER.triggerAchievement(player, "fishing_fanatic_rain");
            }
        }
        data.player.method_7353((class_2561)TextHelper.translatable((String)"enchantment.majruszsenchantments.fishing_fanatic.level_up", (Object[])new Object[0]).method_27692(class_124.field_1067), true);
    }

    private void increaseDamage(OnEntityPreDamaged data) {
        data.damage += (float)EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1309)data.attacker) * this.damageBonus;
        data.spawnMagicParticles = true;
        ItemHelper.damage((class_1309)data.attacker, (class_1304)class_1304.field_6173, (int)1);
    }

    private void reduceAttackSpeed(OnItemEquipped data) {
        float multiplier = (float)Math.pow(this.attackSpeedMultiplier, EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1309)data.entity));
        this.attackSpeed.setValue((double)(multiplier - 1.0f)).apply(data.entity);
    }
}

