/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnExploded;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@AutoInstance
public class FuseCutterEnchantment
extends Handler {
    float maxDistance = 6.0f;
    float cooldownRatio = 1.5f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9090).category(MajruszsEnchantments.IS_SHIELD).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 8).maxLevelCost(level -> 40);
    }

    public FuseCutterEnchantment() {
        super(MajruszsEnchantments.FUSE_CUTTER, FuseCutterEnchantment.class, false);
        OnExploded.listen(this::cancel).addCondition(Condition.isLogicalServer()).addCondition(this::isAnyoneBlockingNearby);
        this.config.define("max_distance", Reader.number(), s -> Float.valueOf(this.maxDistance), (s, v) -> {
            this.maxDistance = ((Float)Range.of((Number)Float.valueOf(1.0f), (Number)Float.valueOf(64.0f)).clamp((Number)v)).floatValue();
        }).define("shield_cooldown_ratio", Reader.number(), s -> Float.valueOf(this.cooldownRatio), (s, v) -> {
            this.cooldownRatio = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void cancel(OnExploded data) {
        class_243 position = AnyPos.from((class_243)data.position).add((Number)0.0, (Number)0.5, (Number)0.0).vec3();
        data.cancelExplosion();
        ParticleEmitter.of((class_2394)class_2398.field_11251).offset(ParticleEmitter.offset((float)(0.125f * data.radius))).speed(0.025f).count(Random.round((double)(12.0f * data.radius))).position(position).emit((class_1937)data.getServerLevel());
        ParticleEmitter.of((class_2394)class_2398.field_11237).offset(ParticleEmitter.offset((float)(0.125f * data.radius))).speed(0.025f).count(Random.round((double)(8.0f * data.radius))).position(position).emit((class_1937)data.getServerLevel());
        SoundEmitter.of((class_3414)class_3417.field_15102).position(position).emit((class_1937)data.getServerLevel());
    }

    private boolean isAnyoneBlockingNearby(OnExploded data) {
        class_238 aabb = class_238.method_29968((class_243)data.position).method_1014((double)this.maxDistance);
        for (class_1309 entity : data.getLevel().method_18467(class_1309.class, aabb)) {
            if (!(entity instanceof class_3222)) continue;
            class_3222 player = (class_3222)entity;
            if (!entity.method_6039() || !EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)ItemHelper.getCurrentlyUsedItem((class_1309)entity))) continue;
            EntityHelper.disableCurrentItem((class_1657)player, (double)(data.radius * this.cooldownRatio));
            return true;
        }
        return false;
    }
}

