/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.platform.Side;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_8567;

@AutoInstance
public class HarvesterEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9090).category(MajruszsEnchantments.IS_HOE).slots((List)EquipmentSlots.HANDS).maxLevel(3).minLevelCost(level -> level * 10).maxLevelCost(level -> level * 10 + 15);
    }

    public HarvesterEnchantment() {
        super(MajruszsEnchantments.HARVESTER, HarvesterEnchantment.class, false);
        OnPlayerInteracted.listen(this::apply).addCondition(data -> data.blockResult != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)data.itemStack)).addCondition(data -> BlockHelper.isCropAtMaxAge((class_1937)data.getLevel(), (class_2338)data.blockResult.method_17777()));
    }

    private void apply(OnPlayerInteracted data) {
        this.collectNearbyCrops(data);
        if (Side.isLogicalServer()) {
            Result result = this.harvestNearbyCrops(data);
            this.spawnItems(data, result);
            this.damageHoe(data, result);
        }
        data.finish();
    }

    private void collectNearbyCrops(OnPlayerInteracted data) {
        int range = EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)data.itemStack) - 1;
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                class_2338 blockPos = AnyPos.from((class_2338)data.blockResult.method_17777()).add((Number)x, (Number)0, (Number)z).block();
                class_2680 blockState = data.getLevel().method_8320(blockPos);
                if (!BlockHelper.isCropAtMaxAge((class_2680)blockState)) continue;
                blockState.method_26204().method_9576(data.getLevel(), blockPos, blockState, data.player);
            }
        }
    }

    private void spawnItems(OnPlayerInteracted data, Result result) {
        result.itemStacks.forEach(itemStack -> class_2248.method_9577((class_1937)data.getLevel(), (class_2338)data.blockResult.method_17777(), (class_1799)itemStack));
    }

    private Result harvestNearbyCrops(OnPlayerInteracted data) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        int count = 0;
        int range = EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)data.itemStack) - 1;
        for (int z = -range; z <= range; ++z) {
            for (int x = -range; x <= range; ++x) {
                Optional<List<class_1799>> drops = this.tryToHarvest(data, x, z);
                if (!drops.isPresent()) continue;
                ++count;
                itemStacks.addAll((Collection<class_1799>)drops.get());
            }
        }
        return new Result(itemStacks, count);
    }

    private Optional<List<class_1799>> tryToHarvest(OnPlayerInteracted data, int x, int z) {
        class_2338 blockPos;
        class_1937 level = data.getLevel();
        class_2680 blockState = level.method_8320(blockPos = AnyPos.from((class_2338)data.blockResult.method_17777()).add((Number)x, (Number)0, (Number)z).block());
        if (!BlockHelper.isCropAtMaxAge((class_2680)blockState)) {
            return Optional.empty();
        }
        class_2248 block = blockState.method_26204();
        class_1792 seed = block.method_9574((class_1922)level, blockPos, blockState).method_7909();
        List drops = blockState.method_26189(new class_8567.class_8568(data.getServerLevel()).method_51874(class_181.field_24424, (Object)AnyPos.from((class_2338)blockPos).center().vec3()).method_51874(class_181.field_1229, (Object)data.itemStack).method_51874(class_181.field_1224, (Object)blockState).method_51874(class_181.field_1226, (Object)data.player));
        for (class_1799 itemStack : drops) {
            if (!itemStack.method_31574(seed)) continue;
            itemStack.method_7939(itemStack.method_7947() - 1);
            level.method_8501(blockPos, block.method_9564());
            return Optional.of(drops);
        }
        for (class_1735 slot : data.player.field_7498.field_7761) {
            class_1799 itemStack = slot.method_7677();
            if (!itemStack.method_31574(seed)) continue;
            itemStack.method_7939(itemStack.method_7947() - 1);
            level.method_8501(blockPos, block.method_9564());
            return Optional.of(drops);
        }
        level.method_8501(blockPos, class_2246.field_10124.method_9564());
        return Optional.of(drops);
    }

    private void damageHoe(OnPlayerInteracted data, Result result) {
        ItemHelper.damage((class_1309)data.player, (class_1268)data.hand, (int)result.cropsCount);
    }

    private record Result(List<class_1799> itemStacks, int cropsCount) {
    }
}

