/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.OnLootingLevelGet;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.mixininterfaces.IMixinProjectile;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_8103;

@AutoInstance
public class HunterEnchantment
extends Handler {
    float penaltyMultiplier = -0.1f;
    float distanceMultiplier = 0.01f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9088).category(MajruszsEnchantments.IS_BOW_OR_CROSSBOW).slots((List)EquipmentSlots.HANDS).maxLevel(3).minLevelCost(level -> level * 9 + 6).maxLevelCost(level -> level * 9 + 26);
    }

    public HunterEnchantment() {
        super(MajruszsEnchantments.HUNTER, HunterEnchantment.class, false);
        OnLootingLevelGet.listen(this::increaseLevel).addCondition(data -> data.source != null).addCondition(data -> data.source.method_48789(class_8103.field_42247)).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)this.getItemStack(data.source)));
        OnEntityPreDamaged.listen(this::modifyDamage).addCondition(data -> data.attacker != null).addCondition(data -> data.source != null).addCondition(data -> data.source.method_48789(class_8103.field_42247)).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)this.getItemStack(data.source)));
        this.config.define("penalty_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.penaltyMultiplier), (s, v) -> {
            this.penaltyMultiplier = ((Float)Range.of((Number)Float.valueOf(-1.0f), (Number)Float.valueOf(0.0f)).clamp((Number)v)).floatValue();
        }).define("distance_multiplier_per_level", Reader.number(), s -> Float.valueOf(this.distanceMultiplier), (s, v) -> {
            this.distanceMultiplier = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void increaseLevel(OnLootingLevelGet data) {
        data.level += EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)this.getItemStack(data.source));
    }

    private void modifyDamage(OnEntityPreDamaged data) {
        float distance = Math.max(data.target.method_5739((class_1297)data.attacker) - 1.0f, 0.0f);
        int level = EnchantmentHelper.getLevel((Supplier)this.enchantment, (class_1799)this.getItemStack(data.source));
        float multiplier = (float)level * (this.penaltyMultiplier + distance * this.distanceMultiplier);
        data.damage *= Math.max(1.0f + multiplier, 0.0f);
        if (multiplier > 0.0f) {
            data.spawnMagicParticles = true;
        }
    }

    private class_1799 getItemStack(class_1282 source) {
        return IMixinProjectile.majruszlibrary$getProjectileWeapon((class_1297)source.method_5526());
    }
}

