/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@AutoInstance
public class LeechEnchantment
extends Handler {
    static int MAX_DURATION = TimeHelper.toTicks((double)30.0);
    float healthChance = 0.1f;
    float hungerChance = 0.1f;
    float effectChance = 0.1f;

    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9088).category(MajruszsEnchantments.IS_MELEE_MINECRAFT).slots((List)EquipmentSlots.MAINHAND).minLevelCost(level -> 20).maxLevelCost(level -> 40);
    }

    public LeechEnchantment() {
        super(MajruszsEnchantments.LEECH, LeechEnchantment.class, false);
        OnEntityDamaged.listen(this::tryToLeechAnything).addCondition(Condition.isLogicalServer()).addCondition(data -> data.attacker != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.attacker));
        this.config.define("health_chance", Reader.number(), s -> Float.valueOf(this.healthChance), (s, v) -> {
            this.healthChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("hunger_chance", Reader.number(), s -> Float.valueOf(this.hungerChance), (s, v) -> {
            this.hungerChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("effect_chance", Reader.number(), s -> Float.valueOf(this.effectChance), (s, v) -> {
            this.effectChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        });
    }

    private void tryToLeechAnything(OnEntityDamaged data) {
        boolean leechedAnything = this.tryToLeech(this.healthChance, this::leechHealth, data);
        leechedAnything = this.tryToLeech(this.hungerChance, this::leechHunger, data) || leechedAnything;
        boolean bl = leechedAnything = this.tryToLeech(this.effectChance, this::leechEffect, data) || leechedAnything;
        if (leechedAnything) {
            this.spawnEffects(data);
        }
    }

    private boolean tryToLeech(float chance, Predicate<OnEntityDamaged> predicate, OnEntityDamaged data) {
        return Random.check((float)chance) && predicate.test(data);
    }

    private boolean leechHealth(OnEntityDamaged data) {
        data.target.method_5643(data.getLevel().method_48963().method_48831(), 1.0f);
        data.attacker.method_6025(1.0f);
        return true;
    }

    private boolean leechHunger(OnEntityDamaged data) {
        class_1309 class_13092 = data.attacker;
        if (class_13092 instanceof class_1657) {
            class_1657 playerAttacker = (class_1657)class_13092;
            class_1702 attackerFood = playerAttacker.method_7344();
            attackerFood.method_7580(Math.min(attackerFood.method_7586() + 1, 20));
            class_1309 class_13093 = data.target;
            if (class_13093 instanceof class_1657) {
                class_1657 playerTarget = (class_1657)class_13093;
                class_1702 targetFood = playerTarget.method_7344();
                targetFood.method_7580(Math.max(targetFood.method_7586() - 1, 0));
            }
            return true;
        }
        return false;
    }

    private boolean leechEffect(OnEntityDamaged data) {
        for (class_1293 effectInstance : data.target.method_6026()) {
            class_1291 effect = effectInstance.method_5579();
            if (!effect.method_5573()) continue;
            int duration = effectInstance.method_48559() ? MAX_DURATION : Math.min(MAX_DURATION, effectInstance.method_5584());
            data.attacker.method_6092(new class_1293(effect, duration, effectInstance.method_5578()));
            data.target.method_6016(effect);
            return true;
        }
        return false;
    }

    private void spawnEffects(OnEntityDamaged data) {
        class_243 from = AnyPos.from((class_243)data.attacker.method_19538()).add((Number)0.0, (Number)((double)data.attacker.method_17682() * 0.75), (Number)0.0).vec3();
        class_243 to = AnyPos.from((class_243)data.target.method_19538()).add((Number)0.0, (Number)((double)data.target.method_17682() * 0.75), (Number)0.0).vec3();
        ParticleEmitter.of((class_2394)class_2398.field_11208).count(Random.round((double)(AnyPos.from((class_243)from).dist(to).floatValue() * 5.0f))).offset(ParticleEmitter.offset((float)0.05f)).position(from).emitLine((class_1937)data.getServerLevel(), to);
        SoundEmitter.of((class_3414)class_3417.field_20613).volume(SoundEmitter.randomized((float)0.25f)).position(from).emit((class_1937)data.getServerLevel());
    }
}

