/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.MajruszLibrary;
import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.entity.EntityNoiseListener;
import com.majruszlibrary.events.OnEntityNoiseCheck;
import com.majruszlibrary.events.OnEntityNoiseReceived;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.OnPlayerTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_39;
import net.minecraft.class_8567;

@AutoInstance
public class SixthSenseEnchantment
extends Handler {
    List<class_2960> chestIds = List.of(class_39.field_38438, class_39.field_38439);
    class_2960 lootId = MajruszsEnchantments.HELPER.getLocation("chests/ancient_city_sixth_sense");
    float glowDuration = 2.0f;

    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public boolean method_8193() {
                return true;
            }

            public boolean method_25949() {
                return false;
            }

            public boolean canEnchantUsingEnchantingTable(class_1799 itemStack) {
                return false;
            }
        }.rarity(class_1887.class_1888.field_9091).category(class_1886.field_9080).slots((List)EquipmentSlots.HEAD).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public SixthSenseEnchantment() {
        super(MajruszsEnchantments.SIXTH_SENSE, SixthSenseEnchantment.class, false);
        EntityNoiseListener.add(class_3222.class);
        OnEntityNoiseCheck.listen(OnEntityNoiseCheck::makeAudible).addCondition(data -> data.listener instanceof class_3222).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)((class_3222)data.listener))).addCondition(Condition.isShiftKeyDown(data -> (class_3222)data.listener)).addCondition(Condition.isOnGround(data -> data.listener));
        OnEntityNoiseReceived.listen(this::highlight).addCondition(data -> data.listener instanceof class_3222).addCondition(data -> data.emitter != data.listener).addCondition(data -> data.emitter != null);
        OnPlayerTicked.listen(this::playSound).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)1.25f)).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)data.player)).addCondition(Condition.isShiftKeyDown(data -> data.player)).addCondition(Condition.isOnGround(data -> data.player));
        OnLootGenerated.listen(this::addToChest).addCondition(Condition.isLogicalServer()).addCondition(data -> this.isEnabled).addCondition(data -> data.origin != null).addCondition(data -> this.chestIds.contains(data.lootId));
        this.config.define("glow_duration", Reader.number(), s -> Float.valueOf(this.glowDuration), (s, v) -> {
            this.glowDuration = ((Float)Range.of((Number)Float.valueOf(0.5f), (Number)Float.valueOf(30.0f)).clamp((Number)v)).floatValue();
        }).define("chest_ids", Reader.list((IReader)Reader.location()), s -> this.chestIds, (s, v) -> {
            this.chestIds = v;
        }).define("loot_id", Reader.location(), s -> this.lootId, (s, v) -> {
            this.lootId = v;
        });
    }

    private void highlight(OnEntityNoiseReceived data) {
        MajruszLibrary.ENTITY_GLOW.sendToClient((class_3222)data.listener, (Object)new EntityHelper.EntityGlow(data.emitter, TimeHelper.toTicks((double)this.glowDuration)));
    }

    private void playSound(OnPlayerTicked data) {
        SoundEmitter.of((class_3414)class_3417.field_38068).volume(SoundEmitter.randomized((float)0.3f)).position(data.player.method_19538()).emit((class_1937)data.getServerLevel());
    }

    private void addToChest(OnLootGenerated data) {
        class_8567 params = new class_8567.class_8568(data.getServerLevel()).method_51874(class_181.field_24424, (Object)data.origin).method_51875(class_173.field_1179);
        data.generatedLoot.addAll((ObjectList)LootHelper.getLootTable((class_2960)this.lootId).method_51878(params));
    }
}

