/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1909;
import net.minecraft.class_1937;
import net.minecraft.class_243;

@AutoInstance
public class SmelterEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9090).category(class_1886.field_9069).slots((List)EquipmentSlots.MAINHAND).minLevelCost(level -> 15).maxLevelCost(level -> 45).compatibility(enchantment -> !(enchantment instanceof class_1909));
    }

    public SmelterEnchantment() {
        super(MajruszsEnchantments.SMELTER, SmelterEnchantment.class, false);
        OnLootGenerated.listen(this::smelt).priority(Priority.LOW).addCondition(data -> data.blockState != null).addCondition(data -> data.origin != null).addCondition(data -> data.tool != null).addCondition(data -> {
            class_1657 player;
            class_1297 patt1737$temp = data.entity;
            return patt1737$temp instanceof class_1657 && !(player = (class_1657)patt1737$temp).method_18276();
        }).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)data.tool));
    }

    private void smelt(OnLootGenerated data) {
        float experience = 0.0f;
        for (int idx = 0; idx < data.generatedLoot.size(); ++idx) {
            Optional result = ItemHelper.tryToSmelt((class_1937)data.getLevel(), (class_1799)((class_1799)data.generatedLoot.get(idx)));
            if (!result.isPresent()) continue;
            experience += ((ItemHelper.SmeltResult)result.get()).experience();
            data.generatedLoot.set(idx, (Object)((ItemHelper.SmeltResult)result.get()).itemStack());
        }
        int totalExperience = Random.round((double)experience);
        if (totalExperience > 0) {
            EntityHelper.spawnExperience((class_1937)data.getLevel(), (class_243)data.origin, (int)totalExperience);
        }
        if (experience > 0.0f) {
            ParticleEmitter.of(MajruszsEnchantments.SMELTER_PARTICLE).count(10).offset(ParticleEmitter.offset((float)0.2f)).speed(0.01f).position(AnyPos.from((class_243)data.origin).center().vec3()).emit((class_1937)data.getServerLevel());
        }
    }
}

