/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.mixininterfaces.IMixinProjectile;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import com.majruszsenchantments.particles.TelekinesisParticleType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

@AutoInstance
public class TelekinesisEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(class_1887.class_1888.field_9090).category(MajruszsEnchantments.IS_TOOL).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 15).maxLevelCost(level -> 45);
    }

    public TelekinesisEnchantment() {
        super(MajruszsEnchantments.TELEKINESIS, TelekinesisEnchantment.class, false);
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (class_1657)data.entity)).priority(Priority.LOWEST).addCondition(data -> data.entity instanceof class_1657).addCondition(data -> data.origin != null).addCondition(data -> data.tool != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)data.tool));
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (class_1657)data.killer)).priority(Priority.LOWEST).addCondition(data -> data.killer instanceof class_1657).addCondition(data -> data.origin != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1309)((class_1657)data.killer)));
        OnLootGenerated.listen(data -> this.addToInventory((OnLootGenerated)data, (class_1657)data.killer)).priority(Priority.LOWEST).addCondition(data -> data.killer instanceof class_1657).addCondition(data -> data.origin != null).addCondition(data -> data.damageSource != null).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (class_1799)IMixinProjectile.majruszlibrary$getProjectileWeapon((class_1297)data.damageSource.method_5526())));
    }

    private void addToInventory(OnLootGenerated data, class_1657 player) {
        if (!data.generatedLoot.removeIf(arg_0 -> ((class_1657)player).method_7270(arg_0))) {
            return;
        }
        SoundEmitter.of((class_3414)class_3417.field_15197).volume(SoundEmitter.randomized((float)0.25f)).position(player.method_19538()).emit((class_1937)data.getServerLevel());
        class_243 from = AnyPos.from((class_243)data.origin).add((Number)0.0, (Number)(data.killer != null && data.entity != null ? (double)data.entity.method_17682() * 0.75 : 0.0), (Number)0.0).vec3();
        class_243 to = AnyPos.from((class_243)player.method_19538()).add((Number)0.0, (Number)((double)player.method_17682() * 0.5), (Number)0.0).vec3();
        AtomicInteger idx = new AtomicInteger();
        double distance = to.method_1022(from);
        int count = Random.round((double)(to.method_1022(from) * 6.0));
        int lifetime = TimeHelper.toTicks((double)0.5) + Random.round((double)(distance * 0.2));
        float pulseSpeed = (float)(1.0 + (double)0.05f * distance);
        ParticleEmitter.of(() -> new TelekinesisParticleType.Options((int)((float)lifetime * ((float)count - 1.0f * (float)idx.getAndUpdate(x -> x + 1)) / (float)count), lifetime, pulseSpeed)).offset(() -> new class_243(0.0, 0.0, 0.0)).speed(0.0f).count(count).position(from).emitLine((class_1937)data.getServerLevel(), to);
    }
}

