/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.part;

import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.StorageCell;
import appeng.blockentity.inventory.AppEngCellInventory;
import appeng.client.render.tesr.CellLedRenderer;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.storage.DriveWatcher;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CellDockPart
extends AEBasePart
implements InternalInventoryHost,
IChestOrDrive,
IPriorityHost,
IStorageProvider {
    @PartModels
    public static final IPartModel MODEL = new PartModel(MEGACells.makeId("part/cell_dock"));
    private final AppEngCellInventory cellInventory = new AppEngCellInventory((InternalInventoryHost)this, 1);
    private DriveWatcher cellWatcher;
    private boolean isCached = false;
    private boolean wasOnline = false;
    private int priority = 0;
    private class_1792 clientCell = class_1802.field_8162;
    private CellState clientCellState = CellState.ABSENT;

    public CellDockPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage(0.5).setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).addService(IStorageProvider.class, (IGridNodeService)this);
        this.cellInventory.setFilter((IAEItemFilter)new CellInventoryFilter());
    }

    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.cellInventory.setItemDirect(0, class_1799.method_7915((class_2487)data.method_10562("cell")));
        this.priority = data.method_10550("priority");
    }

    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        class_2487 cell = new class_2487();
        this.getCell().method_7953(cell);
        data.method_10566("cell", (class_2520)cell);
        data.method_10569("priority", this.priority);
    }

    public boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        class_1792 oldCell = this.clientCell;
        CellState oldCellState = this.clientCellState;
        this.clientCell = (class_1792)class_7923.field_41178.method_10223(data.method_10810());
        this.clientCellState = (CellState)data.method_10818(CellState.class);
        return changed || oldCell != this.clientCell || oldCellState != this.clientCellState;
    }

    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.method_10812(class_7923.field_41178.method_10221((Object)this.getCell().method_7909()));
        this.clientCellState = this.getCellStatus(0);
        data.method_10817((Enum)this.clientCellState);
    }

    public void readVisualStateFromNBT(class_2487 data) {
        super.readVisualStateFromNBT(data);
        try {
            this.clientCell = (class_1792)class_7923.field_41178.method_10223(new class_2960(data.method_10558("cellId")));
        }
        catch (Exception e) {
            MEGACells.LOGGER.warn("Couldn't read cell item for {} from {}", (Object)this, (Object)data);
            this.clientCell = class_1802.field_8162;
        }
        try {
            this.clientCellState = CellState.valueOf((String)data.method_10558("cellStatus"));
        }
        catch (Exception e) {
            MEGACells.LOGGER.warn("Couldn't read cell status for {} from {}", (Object)this, (Object)data);
            this.clientCellState = CellState.ABSENT;
        }
    }

    public void writeVisualStateToNBT(class_2487 data) {
        super.writeVisualStateToNBT(data);
        data.method_10582("cellId", class_7923.field_41178.method_10221((Object)this.getCell().method_7909()).toString());
        data.method_10582("cellStatus", this.getCellStatus(0).name());
    }

    private void recalculateDisplay() {
        CellState cellState = this.getCellStatus(0);
        if (this.clientCellState != cellState) {
            this.getHost().markForUpdate();
            this.clientCellState = cellState;
        }
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        boolean online = this.getMainNode().isOnline();
        if (online != this.wasOnline) {
            this.wasOnline = online;
            IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
            this.recalculateDisplay();
        }
    }

    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!player.method_5770().method_8608()) {
            MenuOpener.open(MEGAMenus.CELL_DOCK, (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
        }
        return true;
    }

    public void addAdditionalDrops(List<class_1799> drops, boolean wrenched) {
        super.addAdditionalDrops(drops, wrenched);
        drops.add(this.getCell());
    }

    public AppEngCellInventory getCellInventory() {
        return this.cellInventory;
    }

    private class_1799 getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public int getCellCount() {
        return 1;
    }

    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Nullable
    public class_1792 getCellItem(int slot) {
        return slot == 0 ? this.cellInventory.getStackInSlot(slot).method_7909() : null;
    }

    @Nullable
    public MEStorage getCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher : null;
    }

    @Nullable
    public StorageCell getOriginalCellInventory(int slot) {
        return slot == 0 && this.cellWatcher != null ? this.cellWatcher.getCell() : null;
    }

    public CellState getCellStatus(int slot) {
        return this.isClientSide() ? this.clientCellState : (slot == 0 && this.cellWatcher != null ? this.cellWatcher.getStatus() : CellState.ABSENT);
    }

    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isOnline()) {
            this.updateState();
            if (this.cellWatcher != null) {
                storageMounts.mount((MEStorage)this.cellWatcher, this.priority);
            }
        }
    }

    public void saveChanges() {
        this.getHost().markForSave();
        this.getHost().markForUpdate();
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (this.isCached) {
            this.isCached = false;
            this.updateState();
        }
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    private void updateState() {
        if (!this.isCached) {
            StorageCell cell;
            this.cellWatcher = null;
            this.cellInventory.setHandler(0, null);
            double power = 0.5;
            if (!this.getCell().method_7960() && (cell = StorageCells.getCellInventory((class_1799)this.getCell(), this::onCellContentChanged)) != null) {
                this.cellWatcher = new DriveWatcher(cell, this::recalculateDisplay);
                this.cellInventory.setHandler(0, cell);
                power += cell.getIdleDrain();
            }
            this.getMainNode().setIdlePowerUsage(power);
            this.isCached = true;
        }
    }

    private void onCellContentChanged() {
        this.getLevel().method_8524(this.getBlockEntity().method_11016());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.isCached = false;
        this.updateState();
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(MEGAMenus.CELL_DOCK, (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public class_1799 getMainMenuIcon() {
        return MEGAItems.CELL_DOCK.stack();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 12.0, 13.0, 13.0, 16.0);
        bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 12.0);
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean requireDynamicRender() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderDynamic(float partialTicks, class_4587 poseStack, class_4597 buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.getLevel() == null || this.clientCell == class_1802.field_8162) {
            return;
        }
        class_2350 front = this.getSide() == class_2350.field_11036 || this.getSide() == class_2350.field_11033 ? class_2350.field_11043 : class_2350.field_11036;
        BlockOrientation orientation = BlockOrientation.get((class_2350)front, (class_2350)this.getSide());
        class_1087 cellModel = MEGACells.Client.PLATFORM.createCellModel(this.clientCell, orientation);
        if (cellModel == null) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(orientation.getQuaternion());
        poseStack.method_46416(-0.1875f, 0.3125f, -0.25f);
        class_310.method_1551().method_1541().method_3350().method_3374((class_1920)this.getLevel(), cellModel, this.getBlockEntity().method_11010(), this.getBlockEntity().method_11016(), poseStack, buffers.getBuffer(class_1921.method_23581()), false, class_5819.method_43047(), 0L, combinedOverlayIn);
        CellLedRenderer.renderLed((IChestOrDrive)this, (int)0, (class_4588)buffers.getBuffer(CellLedRenderer.RENDER_LAYER), (class_4587)poseStack, (float)partialTicks);
        poseStack.method_22909();
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            return StorageCells.isCellHandled((class_1799)stack);
        }
    }
}

