/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.blinkload.client.cache;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import io.github.steveplays28.blinkload.util.CacheUtil;
import io.github.steveplays28.blinkload.util.HashUtil;
import io.github.steveplays28.blinkload.util.ThreadUtil;
import io.github.steveplays28.blinkload.util.resource.json.AtlasTextureIdentifier;
import io.github.steveplays28.blinkload.util.resource.json.JsonUtil;
import io.github.steveplays28.blinkload.util.resource.json.StitchResult;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BlinkLoadCache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)String.format("%s/cache", "blinkload"));
    @NotNull
    private static final File CACHED_DATA_FILE = new File(String.format("%s/atlas_textures_cache.json", CacheUtil.getCachePath()));
    @NotNull
    private static final String MOD_LIST_HASH = HashUtil.calculateHash(HashUtil.getModAndEnabledResourcePackListCommaSeparated());
    @Nullable
    private static CompletableFuture<Map<AtlasTextureIdentifier, StitchResult>> cachedDataCompletableFuture = null;
    @Nullable
    private static Map<AtlasTextureIdentifier, StitchResult> cachedData = null;
    private static boolean hasClientStarted = false;
    @Nullable
    private static Boolean isUpToDate = null;

    public static void initialize() {
        io.github.steveplays28.blinkload.client.event.ClientLifecycleEvent.CLIENT_MAIN_STARTING.register(BlinkLoadCache::loadCachedDataAsync);
        ClientLifecycleEvent.CLIENT_STARTED.register(instance -> {
            hasClientStarted = true;
        });
        io.github.steveplays28.blinkload.client.event.ClientLifecycleEvent.CLIENT_RESOURCE_RELOAD_STARTING.register(BlinkLoadCache::invalidateCache);
        io.github.steveplays28.blinkload.client.event.ClientLifecycleEvent.CLIENT_RESOURCE_RELOAD_FINISHED.register(BlinkLoadCache::writeCacheDataToFileAsync);
    }

    public static boolean isUpToDate() {
        if (isUpToDate == null) {
            isUpToDate = Files.exists(CACHED_DATA_FILE.toPath(), new LinkOption[0]) && HashUtil.compareHashes(MOD_LIST_HASH);
        }
        return isUpToDate;
    }

    public static void invalidateCache() {
        if (!hasClientStarted) {
            return;
        }
        isUpToDate = false;
    }

    @NotNull
    public static Map<AtlasTextureIdentifier, StitchResult> getCachedData() {
        if (cachedData == null) {
            BlinkLoadCache.loadCachedDataAsync().join();
        }
        return cachedData;
    }

    public static void cacheData(@NotNull StitchResult stitchResult) {
        BlinkLoadCache.getCachedData().put(new AtlasTextureIdentifier(stitchResult.getAtlasTextureId(), stitchResult.getMipLevel()), stitchResult);
    }

    @NotNull
    private static CompletableFuture<Map<AtlasTextureIdentifier, StitchResult>> loadCachedDataAsync() {
        if (cachedDataCompletableFuture == null) {
            cachedDataCompletableFuture = CompletableFuture.supplyAsync(BlinkLoadCache::loadCachedData, ThreadUtil.getAtlasTextureIOThreadPoolExecutor()).whenCompleteAsync((cachedData, throwable) -> {
                if (throwable != null) {
                    LOGGER.error("Exception thrown while trying to load the atlas texture cache: ", ExceptionUtils.getRootCause((Throwable)throwable));
                }
                BlinkLoadCache.cachedData = cachedData;
            });
        }
        return cachedDataCompletableFuture;
    }

    @NotNull
    private static Map<AtlasTextureIdentifier, StitchResult> loadCachedData() {
        if (!BlinkLoadCache.isUpToDate()) {
            return new ConcurrentHashMap<AtlasTextureIdentifier, StitchResult>();
        }
        long startTime = System.nanoTime();
        @NotNull ConcurrentHashMap<AtlasTextureIdentifier, StitchResult> cachedData = new ConcurrentHashMap<AtlasTextureIdentifier, StitchResult>();
        try (@NotNull FileReader reader = new FileReader(CACHED_DATA_FILE);){
            StitchResult[] stitchResults = (StitchResult[])JsonUtil.getGson().fromJson((Reader)reader, StitchResult[].class);
            for (int stitchResultIndex = 0; stitchResultIndex < stitchResults.length; ++stitchResultIndex) {
                StitchResult stitchResult = stitchResults[stitchResultIndex];
                cachedData.put(new AtlasTextureIdentifier(stitchResult.getAtlasTextureId(), stitchResult.getMipLevel()), stitchResult);
            }
            LOGGER.info("Loaded atlas textures from cache (took {}ms).", (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return cachedData;
    }

    private static void writeCacheDataToFileAsync() {
        CompletableFuture.runAsync(BlinkLoadCache::writeCacheDataToFile, ThreadUtil.getAtlasTextureIOThreadPoolExecutor());
    }

    private static void writeCacheDataToFile() {
        if (BlinkLoadCache.isUpToDate()) {
            return;
        }
        long startTime = System.nanoTime();
        try {
            File cacheDirectory = CACHED_DATA_FILE.getParentFile();
            FileUtils.deleteDirectory((File)cacheDirectory);
            cacheDirectory.mkdirs();
            HashUtil.saveHash(MOD_LIST_HASH);
        }
        catch (IOException e) {
            LOGGER.error("Exception thrown while re-creating directories and/or saving hash data: ", (Throwable)e);
        }
        try (@NotNull FileWriter fileWriter = new FileWriter(CACHED_DATA_FILE);){
            fileWriter.write(JsonUtil.getGson().toJson(BlinkLoadCache.getCachedData().values()));
        }
        catch (IOException e) {
            LOGGER.error("Exception thrown while writing cache data to file ({}): {}", (Object)CACHED_DATA_FILE, (Object)e);
        }
        isUpToDate = true;
        LOGGER.info("Saved atlas textures to cache ({}; took {}ms).", (Object)CACHED_DATA_FILE, (Object)TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS));
    }
}

