/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.blinkload.mixin.client.texture;

import io.github.steveplays28.blinkload.client.cache.BlinkLoadCache;
import io.github.steveplays28.blinkload.mixin.client.accessor.SpriteContentsAccessor;
import io.github.steveplays28.blinkload.util.resource.json.AtlasTextureIdentifier;
import io.github.steveplays28.blinkload.util.resource.json.StitchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_7766.class})
public class SpriteLoaderMixin {
    @Inject(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/Identifier;ILjava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")}, cancellable=true)
    private void blinkload$loadAtlasTexturesFromCache(@NotNull class_3300 resourceManager, @NotNull class_2960 atlasTextureId, int mipLevel, @NotNull Executor executor, @NotNull CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> cir) {
        if (!BlinkLoadCache.isUpToDate()) {
            return;
        }
        @NotNull HashMap<K, V> atlasTextureRegions = new HashMap();
        StitchResult stitchResult = BlinkLoadCache.getCachedData().get(new AtlasTextureIdentifier(atlasTextureId, mipLevel));
        if (stitchResult == null) {
            return;
        }
        cir.setReturnValue(CompletableFuture.supplyAsync(() -> {
            StitchResult.AtlasTextureRegion[] stitchResultAtlasTextureRegions = stitchResult.getAtlasTextureRegions();
            for (int stitchResultAtlasTextureRegionIndex = 0; stitchResultAtlasTextureRegionIndex < stitchResultAtlasTextureRegions.length; ++stitchResultAtlasTextureRegionIndex) {
                StitchResult.AtlasTextureRegion.Sprite sprite;
                StitchResult.AtlasTextureRegion atlasTextureRegion = stitchResultAtlasTextureRegions[stitchResultAtlasTextureRegionIndex];
                class_2960 atlasTextureRegionId = atlasTextureRegion.getAtlasTextureRegionId();
                if (atlasTextureRegionId == null || (sprite = atlasTextureRegion.getSprite()) == null) continue;
                class_2960 spriteId = sprite.getIdentifier();
                class_1011 spriteMipmapLevel0Image = sprite.getMipmapLevel0Image();
                class_1011[] spriteMipmapLevelsImages = sprite.getMipmapLevelsImages();
                if (spriteId == null || spriteMipmapLevel0Image == null || spriteMipmapLevelsImages == null) continue;
                class_7764 spriteContents = new class_7764(spriteId, new class_7771(atlasTextureRegion.getWidth(), atlasTextureRegion.getHeight()), spriteMipmapLevel0Image, class_1079.field_21768);
                ((SpriteContentsAccessor)spriteContents).setMipmapLevelsImages(spriteMipmapLevelsImages);
                atlasTextureRegions.put(spriteId, new class_1058(atlasTextureRegionId, spriteContents, stitchResult.getWidth(), stitchResult.getHeight(), atlasTextureRegion.getX(), atlasTextureRegion.getY()));
            }
            return new class_7766.class_7767(stitchResult.getWidth(), stitchResult.getHeight(), stitchResult.getMipLevel(), (class_1058)atlasTextureRegions.get(class_1047.method_4539()), atlasTextureRegions, CompletableFuture.completedFuture(null));
        }, executor));
    }

    @Inject(method={"load(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/Identifier;ILjava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private void blinkload$saveAtlasTextures(@NotNull class_3300 resourceManager, @NotNull class_2960 atlasTextureId, int mipLevel, @NotNull Executor executor, @NotNull CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> cir) {
        ((CompletableFuture)cir.getReturnValue()).thenAccept(incompleteStitchResult -> incompleteStitchResult.method_45845().thenAccept(stitchResult -> {
            if (BlinkLoadCache.isUpToDate()) {
                return;
            }
            Map stitchResultAtlasTextureRegions = stitchResult.comp_1044();
            @NotNull ArrayList<StitchResult.AtlasTextureRegion> atlasTextureRegions = new ArrayList<StitchResult.AtlasTextureRegion>();
            for (Map.Entry stitchResultAtlasTextureRegion : stitchResultAtlasTextureRegions.entrySet()) {
                if (stitchResultAtlasTextureRegion == null) continue;
                class_2960 atlasIdentifier = ((class_1058)stitchResultAtlasTextureRegion.getValue()).method_45852();
                class_2960 spriteIdentifier = (class_2960)stitchResultAtlasTextureRegion.getKey();
                SpriteContentsAccessor spriteContents = (SpriteContentsAccessor)((class_1058)stitchResultAtlasTextureRegion.getValue()).method_45851();
                int x = ((class_1058)stitchResultAtlasTextureRegion.getValue()).method_35806();
                int y = ((class_1058)stitchResultAtlasTextureRegion.getValue()).method_35807();
                int width = ((class_1058)stitchResultAtlasTextureRegion.getValue()).method_45851().method_45807();
                int height = ((class_1058)stitchResultAtlasTextureRegion.getValue()).method_45851().method_45815();
                atlasTextureRegions.add(new StitchResult.AtlasTextureRegion(atlasIdentifier, new StitchResult.AtlasTextureRegion.Sprite(spriteIdentifier, spriteContents.getImage(), spriteContents.getMipmapLevelsImages()), width, height, x, y));
            }
            BlinkLoadCache.cacheData(new StitchResult(atlasTextureId, stitchResult.comp_1040(), stitchResult.comp_1041(), stitchResult.comp_1042(), (StitchResult.AtlasTextureRegion[])atlasTextureRegions.toArray(StitchResult.AtlasTextureRegion[]::new)));
        }));
    }
}

