/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.blinkload.util;

import com.google.common.hash.Hashing;
import io.github.steveplays28.blinkload.BlinkLoad;
import io.github.steveplays28.blinkload.util.CacheUtil;
import io.github.steveplays28.blinkload.util.ModUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HashUtil {
    @NotNull
    private static final File CACHED_HASH_FILE = new File(String.format("%s/mod_and_enabled_resource_pack_list_hash", CacheUtil.getCachePath()));
    @NotNull
    private static final String[] nameFilterSubstrings = new String[]{"generated"};

    @NotNull
    public static String getModAndEnabledResourcePackListCommaSeparated() {
        List<String> modAndResourcePackNames = ModUtil.getModListNames();
        modAndResourcePackNames.addAll(ModUtil.getEnabledResourcePackNames());
        modAndResourcePackNames.sort(String::compareToIgnoreCase);
        @NotNull ArrayList<String> filteredNames = new ArrayList<String>();
        for (String name : modAndResourcePackNames) {
            if (Arrays.stream(nameFilterSubstrings).noneMatch(name::contains)) continue;
            filteredNames.add(name);
        }
        modAndResourcePackNames.removeAll(filteredNames);
        BlinkLoad.LOGGER.info("Mods/resource packs containing a filtered substring: {}", (Object)StringUtils.join(filteredNames, (String)", "));
        return StringUtils.join(modAndResourcePackNames, (String)", ");
    }

    @NotNull
    public static String calculateHash(@NotNull String input) {
        return Hashing.murmur3_128((int)1).hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
    }

    public static void saveHash(@NotNull String hash) {
        try {
            CACHED_HASH_FILE.getParentFile().mkdirs();
            Files.write(CACHED_HASH_FILE.toPath(), hash.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BlinkLoad.LOGGER.error("Exception occurred while saving mod list hash:", (Throwable)e);
        }
    }

    @Nullable
    public static String loadHash() {
        try {
            Path filePath = CACHED_HASH_FILE.toPath();
            if (!Files.exists(filePath, new LinkOption[0])) {
                return null;
            }
            return new String(Files.readAllBytes(filePath));
        }
        catch (IOException e) {
            BlinkLoad.LOGGER.error("Exception occurred while loading mod list hash:", (Throwable)e);
            return null;
        }
    }

    public static boolean compareHashes(String currentHash) {
        @Nullable String cachedHash = HashUtil.loadHash();
        if (cachedHash == null) {
            BlinkLoad.LOGGER.info("Mod list hash file does not exist.");
        }
        if (cachedHash != null && cachedHash.equals(currentHash)) {
            BlinkLoad.LOGGER.info("Mod list hash ({}) matches with cache ({}). Continuing loading.", (Object)currentHash, (Object)cachedHash);
            return true;
        }
        BlinkLoad.LOGGER.info("Mod list hash ({}) doesn't match with cache ({}).", (Object)currentHash, (Object)cachedHash);
        return false;
    }
}

