/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.blinkload.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.steveplays28.blinkload.util.fabric.ModUtilImpl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)String.format("%s/mod_util", "blinkload"));

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModPresent(String id) {
        return ModUtilImpl.isModPresent(id);
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static Path getGameDirectory() {
        return ModUtilImpl.getGameDirectory();
    }

    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static List<String> getModListNames() {
        return ModUtilImpl.getModListNames();
    }

    @NotNull
    public static List<String> getEnabledResourcePackNames() {
        @NotNull ArrayList<String> enabledResourcePackNames = new ArrayList<String>();
        try (@NotNull BufferedReader bufferedFileReader = new BufferedReader(new FileReader(ModUtil.getGameDirectory().resolve("options.txt").toFile()));){
            bufferedFileReader.lines().forEach(line -> {
                if (!line.contains("resourcePacks")) {
                    return;
                }
                String[] rawEnabledResourcePackNamesOption = line.split("\\[");
                if (rawEnabledResourcePackNamesOption.length < 2) {
                    return;
                }
                String rawEnabledResourcePackNames = rawEnabledResourcePackNamesOption[1].replace("]", "");
                enabledResourcePackNames.addAll(List.of(rawEnabledResourcePackNames.split(",")));
            });
        }
        catch (IOException e) {
            LOGGER.error("Exception occurred while getting enabled resource pack names: ", (Throwable)e);
        }
        return enabledResourcePackNames;
    }
}

