/*
 * Decompiled with CFR 0.152.
 */
package io.github.steveplays28.blinkload.util.resource.json.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class NativeImageAdapter
implements JsonSerializer<class_1011>,
JsonDeserializer<class_1011> {
    @Nullable
    public class_1011 deserialize(@NotNull JsonElement json, Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        byte[] nativeImageBytes = (byte[])context.deserialize(json, byte[].class);
        try {
            ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)nativeImageBytes.length);
            byteBuffer.put(nativeImageBytes);
            byteBuffer.rewind();
            class_1011 nativeImage = class_1011.method_4324((ByteBuffer)byteBuffer);
            MemoryUtil.memFree((Buffer)byteBuffer);
            return nativeImage;
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public JsonElement serialize(@Nullable class_1011 src, Type typeOfSrc, @NotNull JsonSerializationContext context) {
        byte[] nativeImageBytes;
        if (src == null) {
            return JsonNull.INSTANCE;
        }
        try {
            nativeImageBytes = src.method_24036();
        }
        catch (IOException e) {
            return JsonNull.INSTANCE;
        }
        return context.serialize((Object)nativeImageBytes, byte[].class);
    }
}

